/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.client;

import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCIndicationErrLogger;
import java.util.Vector;

public class HSCCltEventQueue {
    private Vector mEvents = new Vector();
    private HSCIndicationErrLogger mErrLogger;

    public HSCCltEventQueue(HSCIndicationErrLogger hSCIndicationErrLogger) {
        this.mErrLogger = hSCIndicationErrLogger;
    }

    public synchronized void addEvent(HSCEvent hSCEvent) {
        this.mEvents.addElement(hSCEvent);
        this.notify();
    }

    public int getQueueSize() {
        return this.mEvents.size();
    }

    public synchronized long getLastEventTime() {
        if (this.mEvents.size() > 0) {
            HSCEvent hSCEvent = (HSCEvent)this.mEvents.elementAt(this.mEvents.size() - 1);
            return hSCEvent.getTimestamp();
        }
        return 0L;
    }

    public synchronized HSCEvent getEvent() {
        while (this.mEvents.size() == 0) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {
                if (this.mErrLogger != null) {
                    this.mErrLogger.logException(throwable);
                    continue;
                }
                throwable.printStackTrace();
            }
        }
        return (HSCEvent)this.mEvents.remove(0);
    }

    public synchronized void clear() {
        this.mEvents.removeAllElements();
    }
}

